/*
 *  This file is part of "TweetyProject", a collection of Java libraries for
 *  logical aspects of artificial intelligence and knowledge representation.
 *
 *  TweetyProject is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version 3 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 *  Copyright 2016 The TweetyProject Team <http://tweetyproject.org/contact/>
 */
/* Generated By:JavaCC: Do not edit this line. Token.java Version 5.0 */
/* JavaCCOptions:TOKEN_EXTENDS=,KEEP_LINE_COL=null,SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
package org.tweetyproject.logics.rpcl.parser.rpclcondensedprobabilitydistributionparser;

/**
 * Describes the input token stream.
 */

public class Token implements java.io.Serializable {

  /**
   * The version identifier for this Serializable class.
   * Increment only if the <i>serialized</i> form of the
   * class changes.
   */
  private static final long serialVersionUID = 1L;

  /**
   * An integer that describes the kind of this token. This numbering
   * system is determined by JavaCCParser, and a table of these numbers is
   * stored in the file ...Constants.java.
   */
  public int kind;

  /** The line number of the first character of this Token. */
  public int beginLine;
  /** The column number of the first character of this Token. */
  public int beginColumn;
  /** The line number of the last character of this Token. */
  public int endLine;
  /** The column number of the last character of this Token. */
  public int endColumn;

  /**
   * The string image of the token.
   */
  public String image;

  /**
   * A reference to the next regular (non-special) token from the input
   * stream. If this is the last token from the input stream, or if the
   * token manager has not read tokens beyond this one, this field is
   * set to null. This is true only if this token is also a regular
   * token. Otherwise, see below for a description of the contents of
   * this field.
   */
  public Token next;

  /**
   * This field is used to access special tokens that occur prior to this
   * token, but after the immediately preceding regular (non-special) token.
   * If there are no such special tokens, this field is set to null.
   * When there are more than one such special token, this field refers
   * to the last of these special tokens, which in turn refers to the next
   * previous special token through its specialToken field, and so on
   * until the first special token (whose specialToken field is null).
   * The next fields of special tokens refer to other special tokens that
   * immediately follow it (without an intervening regular token). If there
   * is no such token, this field is null.
   */
  public Token specialToken;

  /**
   * An optional attribute value of the Token.
   * Tokens which are not used as syntactic sugar will often contain
   * meaningful values that will be used later on by the compiler or
   * interpreter. This attribute value is often different from the image.
   * Any subclass of Token that actually wants to return a non-null value can
   * override this method as appropriate.
   * @return value
   */
  public Object getValue() {
    return null;
  }

  /**
   * No-argument constructor
   */
  public Token() {
  }

  /**
   * Constructs a new token for the specified Image.
   *
   * @param kind kind of token
   *
   */
  public Token(int kind) {
    this(kind, null);
  }

  /**
   * Constructs a new token for the specified Image and Kind.
   *
   * @param kind  kind of token
   * @param image the image
   */
  public Token(int kind, String image) {
    this.kind = kind;
    this.image = image;
  }

  /**
   * Returns the image.
   */
  @Override
  public String toString() {
    return image;
  }

  /**
   * Creates and returns a new {@code Token} object based on the specified token
   * kind.
   * By default, this method returns a basic {@code Token} object. However, if you
   * need
   * to return instances of a subclass of {@code Token} for specific token kinds,
   * you can
   * customize this method by adding cases to the switch statement.
   *
   * @param ofKind The integer value representing the kind of the token to be
   *               created.
   * @param image  The string representation of the token's value.
   * @return A new {@code Token} object, or a subclass of {@code Token} if
   *         customized in the switch statement.
   */
  public static Token newToken(int ofKind, String image) {
    switch (ofKind) {
      default:
        return new Token(ofKind, image);
    }
  }

  /**
   *
   * Return new token
   * @param ofKind kind of token
   * @return new token
   */
  public static Token newToken(int ofKind) {
    return newToken(ofKind, null);
  }

}
/*
 * JavaCC - OriginalChecksum=84f75de7cd5edcb291ea3528aad0e151 (do not edit this
 * line)
 */
