/* Generated By:JJTree&JavaCC: Do not edit this line. ASPParser.java */
package org.tweetyproject.lp.asp.parser;
import java.io.*;
import org.tweetyproject.lp.asp.syntax.*;
import org.tweetyproject.lp.asp.semantics.*;

/**
 *
 * Parser for ASP programs in the ASP-Core-2 syntax
 * (<a href="https://www.mat.unical.it/aspcomp2013/files/ASP-CORE-2.03c.pdf">https://www.mat.unical.it/aspcomp2013/files/ASP-CORE-2.03c.pdf</a>).
 * and <a href="http://www.dlvsystem.com/html/DLV_User_Manual.html">DLV</a>
 * input syntaxes and provides additional methods for parsing answer sets given by the DLV and Clingo solvers.
 * <br>See {@link org.tweetyproject.lp.asp.examples.ASPParserExample} for examples on how to use this parser.
 * <br>
 * <br> Note for developers: This parser is generated by JavaCC. To make changes to the grammar, edit "ASPParser.jjt". Then invoke
 * the JJTree preprocessor by calling "jjtree ASPParser.jjt" on the command line (this generates the .jj file). Then
 * run "javacc ASPParser.jj" to generate the parser (i.e. the ASPParser class and the various AST classes).
 * In many cases you will also have to edit the {@link org.tweetyproject.lp.asp.parser.InstantiateVisitor}
 * class which defines how the AST nodes are parsed into TweetyProject's syntax classes.
 * <br> See <a href="https://javacc.github.io/javacc/">https://javacc.github.io/javacc/</a> for more information on JavaCC.
 * <br>
 * <br>
 * The EBNF grammar for this parser is given as follows: <br>
 * PROGRAM ::== (STATEMENT)* (QUERY)? <br>
 * QUERY ::== LITERAL "?" <br>
 * STATEMENT ::== ":-" BODY_ELEMENTS "." | HEAD (":-" BODY_ELEMENTS)? "." | ":~" | BODY_ELEMENTS "." | OPTIMIZE "." | META <br>
 * HEAD ::== (LITERAL ("|" | "v"))* LITERAL | CHOICE | AGGREGATE <br>
 * BODY_ELEMENTS ::== (BODY_ELEMENTS ",")? BODY_ELEMENT <br>
 * BODY_ELEMENT ::== NAF_LITERAL | ("not")? AGGREGATE <br>
 * CHOICE ::== (TERM BINOP)? "{" CHOICE_ELEMENTS "}" (BINOP TERM)? <br>
 * CHOICE_ELEMENTS ::== (CHOICE_ELEMENTS ";")? CHOICE_ELEMENT <br>
 * CHOICE_ELEMENT ::== LITERAL (":" NAF_LITERALS)? <br>
 * AGGREGATE ::== (TERM BINOP)? AGGREGATE_FUNCTION "{" AGGREGATE_ELEMENTS "}" (BINOP TERM)? <br>
 * AGGREGATE_ELEMENTS ::== (AGGREGATE_ELEMENTS ";")? AGGREGATE_ELEMENT <br>
 * AGGREGATE_ELEMENT ::== (Terms)? (":" NAF_LITERALS)? <br>
 * AGGREGATE_FUNCTION ::== "#max" | "#min" | "#count" | "#sum" | "#sum+" | "#times" <br>
 * OPTIMIZE ::== OPTIMIZE_FUNCTION "{" (OPTIMIZE_ELEMENTS)? "}" <br>
 * OPTIMIZE_ELEMENTS ::== (OPTIMIZE_ELEMENTS ";")? OPTIMIZE_ELEMENT <br>
 * OPTIMIZE_ELEMENT ::== WEIGHT_AT_LEVEL (":" NAF_LITERALS)? <br>
 * OPTIMIZE_FUNCTION ::== "#maximize" | "#maximise" | "#minimize"| "#minimise" <br>
 * META ::== "#show " ID "/" NUMBER | "#maxint" "=" "NUMBER | "#const" ID "=" ID
 * WEIGHT_AT_LEVEL ::== TERM ("@" TERM)? ("," TERMS)? <br>
 * NAF_LITERALS ::== (NAF_LITERALS ",")? NAF_LITERAL <br>
 * NAF_LITERAL ::== ("not")? LITERAL | BUILTIN_ATOM <br>
 * LITERAL ::== ("-")? (ID | DLV_ID | CLINGO_ID) ("(" Terms ")")? <br>
 * BUILTIN_ATOM ::== TERM BINOP TERM | DLV_ARITHMETIC_ID "(" Terms ")" | ARITHOP "(" TERM "," TERM "," TERM ")" <br>
 * BINOP ::== "=" | "!=" |"&lt;&gt;" | "&lt;" | "&gt;" | "&lt;=" | "&gt;=" <br>
 * TERMS ::== (TERMS ",")? TERM <br>
 * TERM ::== ID ("(" TERMS ")")? | NUMBER | STRING | VARIABLE | "_" | "(" TERM
 * ")" | "-" TERM | TERM ARITHOP TERM <br>
 * ARITHOP ::== "+" | "-" | "*" | "/" | "\" <br>
 * DLV_ARITHMETIC_ID ::== "#succ" | "#int" | "#prec" | "#mod" <br>
 * DLV_ID ::== "#rand"|"#int"|"#absdiff"|"#append"|"#delnth"|"#flatten"|"#getnth"|"#head"|"#insLast"|"#insnth"|"#last"|"#length"|"#member"|"#reverse"|"#subList"|"#tail" <br>
 * CLINGO_ID ::== "#true"|"#false" <br>
 * <br>
 * where ID is a sequence of letters, numbers, and "_" that starts with a
 * lowercase letter, VARIABLE is a sequence of letters, numbers, and "_" that
 * starts with an uppercase letter, STRING is a sequence of arbitrary characters
 * surrounded by quotation marks ("...") and NUMBER is a sequence of numbers. <br>
 * Single-line comments (starting with "%") and multi-line-comments (starting with "%*", ending with "*%") are ignored by the parser.
 * <br>
 * <br> The grammar given above is mostly equivalent to the ASP-Core-2 grammar. The main differences are that some variations in symbols are
 * supported (such as DLV using "v" instead of "|") and that special constructs from Clingo and DLV are allowed:
 * <br> - #show statements (Clingo): The whitelisted atoms are added to the program's outputPredicateWhitelist and can be used by ClingoSolver if enabled
 * with ClingoSolver.toggleOutputWhitelist(true)
 * <br> - #succ, #prec, #mod predicates, +(X,Y,Z), -(X,Y,Z), *(X,Y,Z), /(X,Y,Z) (DLV): They are converted into equivalent built-in atoms (clingo syntax)
 * <br> - #maxint statements: They are used in place of the integerMaximum parameter when calling solvers
 * <br> - #const constants: They are added to the program's additionalOptions and are automatically used by ClingoSolver and DLVSolver
 * <br> - other arithmetic predicates (such as #int) and list predicates (such as #append) from DLV: They are parsed as special predicates
 * that can only be used with the DLV solver but not with Clingo
 * <br> Other Clingo/DLV meta-statements (such as #include, #external, #program, #script) are ignored.
 * <br>
 *
 * @author Anna Gessler
 *
 */
public class ASPParser/*@bgen(jjtree)*/implements ASPParserTreeConstants, ASPParserConstants {/*@bgen(jjtree)*/
	/**parser state	 */
  protected JJTASPParserState jjtree = new JJTASPParserState();private static ASPParser oneThreadParser = new ASPParser(new StringReader(""));

  /** the visitor */
 private static InstantiateVisitor visitor = new InstantiateVisitor();

 /**
  * Parse the programm
  * @param program StringReader
  * @return StringReader
  * @throws ParseException StringReader
  */
 public static Program parseProgram(String program) throws ParseException
  {
    return parseProgram(new StringReader(program));
  }

 /**
  * parse the program
  * @param reader Reader
  * @return Reader
  * @throws ParseException Reader
  */
 public static Program parseProgram(Reader reader) throws ParseException
  {
    oneThreadParser.ReInit(reader);
    return visitor.visit(oneThreadParser.Program(), null);
  }

 /**
  * Parse the rule
  * @param rule ASPRule
  * @return ASPRule
  * @throws ParseException ASPRule
  */
   public static ASPRule parseRule(String rule) throws ParseException
  {
    return parseRule(new StringReader(rule));
  }

   /**
    * Parse the rule
    * @param reader ASPRule
    * @return ASPRule
    * @throws ParseException ASPRule
    */
 public static ASPRule parseRule(Reader reader) throws ParseException
  {
    oneThreadParser.ReInit(reader);
    return visitor.visit(oneThreadParser.Statement(), null);
  }

 /**
  * Parse AnswerSet
  * @param answerSet AnswerSet
  * @return AnswerSet
  * @throws ParseException AnswerSet
  */
    public static AnswerSet parseAnswerSet(String answerSet) throws ParseException
  {
    return parseAnswerSet(new StringReader(answerSet));
  }

    /**
     * Parse parseAnswerSet
     * @param reader AnswerSet
     * @return AnswerSet
     * @throws ParseException AnswerSet
     */
  public static AnswerSet parseAnswerSet(Reader reader) throws ParseException
  {
    oneThreadParser.ReInit(reader);
    return visitor.visit(oneThreadParser.AnswerSet(), null);
  }

  /**
   * Constructor
   * @return AnswerSet
   * @throws ParseException AnwerSet
   */
  final public ASTAnswerSet AnswerSet() throws ParseException {
 /*@bgen(jjtree) AnswerSet */
  ASTAnswerSet jjtn000 = new ASTAnswerSet(JJTANSWERSET);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ID:
        case MINUS:
        case DLV_ID:
        case CLINGO_ID:
          ;
          break;
        default:
          jj_la1[0] = jj_gen;
          break label_1;
        }
        ClassicalLiteral();
      }
       jjtree.closeNodeScope(jjtn000, true);
       jjtc000 = false;
       {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
       if (jjtc000) {
         jjtree.clearNodeScope(jjtn000);
         jjtc000 = false;
       } else {
         jjtree.popNode();
       }
       if (jjte000 instanceof RuntimeException) {
         {if (true) throw (RuntimeException)jjte000;}
       }
       if (jjte000 instanceof ParseException) {
         {if (true) throw (ParseException)jjte000;}
       }
       {if (true) throw (Error)jjte000;}
    } finally {
       if (jjtc000) {
         jjtree.closeNodeScope(jjtn000, true);
       }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   * Constructor
   * @return Program
   * @throws ParseException Program
   */
  final public ASTProgram Program() throws ParseException {
 /*@bgen(jjtree) Program */
  ASTProgram jjtn000 = new ASTProgram(JJTPROGRAM);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      if (jj_2_1(2147483647)) {
        Statements();
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
      case MINUS:
      case DLV_ID:
      case CLINGO_ID:
        Query();
        break;
      default:
        jj_la1[1] = jj_gen;
        ;
      }
      jj_consume_token(0);
       jjtree.closeNodeScope(jjtn000, true);
       jjtc000 = false;
       {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
       if (jjtc000) {
         jjtree.clearNodeScope(jjtn000);
         jjtc000 = false;
       } else {
         jjtree.popNode();
       }
       if (jjte000 instanceof RuntimeException) {
         {if (true) throw (RuntimeException)jjte000;}
       }
       if (jjte000 instanceof ParseException) {
         {if (true) throw (ParseException)jjte000;}
       }
       {if (true) throw (Error)jjte000;}
    } finally {
       if (jjtc000) {
         jjtree.closeNodeScope(jjtn000, true);
       }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * Return RuleList
   * @return RuleList
   * @throws ParseException RuleList
   */
  final public ASTRuleList Statements() throws ParseException {
 /*@bgen(jjtree) RuleList */
  ASTRuleList jjtn000 = new ASTRuleList(JJTRULELIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      label_2:
      while (true) {
        Statement();
        if (jj_2_2(2147483647)) {
          ;
        } else {
          break label_2;
        }
      }
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * Return Query
   * @return Query
   * @throws ParseException Query
   */
  final public ASTQuery Query() throws ParseException {
 /*@bgen(jjtree) Query */
  ASTQuery jjtn000 = new ASTQuery(JJTQUERY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      ClassicalLiteral();
      jj_consume_token(QUERY_MARK);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * Return Rule
   * @return Rule
   * @throws ParseException Rule
   */
  final public ASTRule Statement() throws ParseException {
 /*@bgen(jjtree) Rule */
  ASTRule jjtn000 = new ASTRule(JJTRULE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONS:
        jj_consume_token(CONS);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NAF:
        case ID:
        case VARIABLE:
        case STRING:
        case NUMBER:
        case ANONYMOUS_VARIABLE:
        case PLUS:
        case MINUS:
        case TIMES:
        case DIV:
        case MODULO:
        case PAREN_OPEN:
        case EQUAL:
        case UNEQUAL:
        case LESS:
        case GREATER:
        case LESS_OR_EQ:
        case GREATER_OR_EQ:
        case AGGREGATE_COUNT:
        case AGGREGATE_MAX:
        case AGGREGATE_MIN:
        case AGGREGATE_SUM:
        case AGGREGATE_SUM_PLUS:
        case AGGREGATE_TIMES:
        case DLV_ARITHMETIC_ID:
        case DLV_ID:
        case CLINGO_ID:
          Body();
          break;
        default:
          jj_la1[2] = jj_gen;
          ;
        }
        jj_consume_token(DOT);
        break;
      case ID:
      case VARIABLE:
      case STRING:
      case NUMBER:
      case ANONYMOUS_VARIABLE:
      case MINUS:
      case PAREN_OPEN:
      case CURLY_OPEN:
      case AGGREGATE_COUNT:
      case AGGREGATE_MAX:
      case AGGREGATE_MIN:
      case AGGREGATE_SUM:
      case AGGREGATE_SUM_PLUS:
      case AGGREGATE_TIMES:
      case DLV_ID:
      case CLINGO_ID:
        Head();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CONS:
          jj_consume_token(CONS);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NAF:
          case ID:
          case VARIABLE:
          case STRING:
          case NUMBER:
          case ANONYMOUS_VARIABLE:
          case PLUS:
          case MINUS:
          case TIMES:
          case DIV:
          case MODULO:
          case PAREN_OPEN:
          case EQUAL:
          case UNEQUAL:
          case LESS:
          case GREATER:
          case LESS_OR_EQ:
          case GREATER_OR_EQ:
          case AGGREGATE_COUNT:
          case AGGREGATE_MAX:
          case AGGREGATE_MIN:
          case AGGREGATE_SUM:
          case AGGREGATE_SUM_PLUS:
          case AGGREGATE_TIMES:
          case DLV_ARITHMETIC_ID:
          case DLV_ID:
          case CLINGO_ID:
            Body();
            break;
          default:
            jj_la1[3] = jj_gen;
            ;
          }
          break;
        default:
          jj_la1[4] = jj_gen;
          ;
        }
        jj_consume_token(DOT);
        break;
      case WCONS:
        jj_consume_token(WCONS);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NAF:
        case ID:
        case VARIABLE:
        case STRING:
        case NUMBER:
        case ANONYMOUS_VARIABLE:
        case PLUS:
        case MINUS:
        case TIMES:
        case DIV:
        case MODULO:
        case PAREN_OPEN:
        case EQUAL:
        case UNEQUAL:
        case LESS:
        case GREATER:
        case LESS_OR_EQ:
        case GREATER_OR_EQ:
        case AGGREGATE_COUNT:
        case AGGREGATE_MAX:
        case AGGREGATE_MIN:
        case AGGREGATE_SUM:
        case AGGREGATE_SUM_PLUS:
        case AGGREGATE_TIMES:
        case DLV_ARITHMETIC_ID:
        case DLV_ID:
        case CLINGO_ID:
          Body();
          break;
        default:
          jj_la1[5] = jj_gen;
          ;
        }
        jj_consume_token(DOT);
        jj_consume_token(SQUARE_OPEN);
        WeightAtLevel();
        jj_consume_token(SQUARE_CLOSE);
        break;
      case MINIMIZE:
      case MAXIMIZE:
        Optimize();
        jj_consume_token(DOT);
        break;
      case CLINGO_SHOW:
      case META_MAXINT:
      case META_CONST:
      case META_OTHER:
        MetaStatement();
        jj_consume_token(DOT);
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * Return Head
   * @return Head
   * @throws ParseException Head
   */
  final public ASTHead Head() throws ParseException {
 /*@bgen(jjtree) Head */
  ASTHead jjtn000 = new ASTHead(JJTHEAD);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      if (jj_2_3(2147483647)) {
        Choice();
      } else if (jj_2_4(2147483647)) {
        Aggregate();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ID:
        case MINUS:
        case DLV_ID:
        case CLINGO_ID:
          Disjunction();
          break;
        default:
          jj_la1[7] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * Return BodyList
   * @return BodyList
   * @throws ParseException BodyList
   */
  final public ASTBodyList Body() throws ParseException {
 /*@bgen(jjtree) BodyList */
  ASTBodyList jjtn000 = new ASTBodyList(JJTBODYLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      label_3:
      while (true) {
        if (jj_2_5(2147483647)) {
          ;
        } else {
          break label_3;
        }
        Body1();
        jj_consume_token(COMMA);
      }
      Body1();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * Return Body
   * @return Body
   * @throws ParseException Body
   */
  final public ASTBody Body1() throws ParseException {
                        /*@bgen(jjtree) Body */
  ASTBody jjtn000 = new ASTBody(JJTBODY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      if (jj_2_6(2147483647)) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NAF:
          jj_consume_token(NAF);
                                                                 jjtn000.nafneg(true);
          break;
        default:
          jj_la1[8] = jj_gen;
          ;
        }
        Aggregate();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NAF:
        case ID:
        case VARIABLE:
        case STRING:
        case NUMBER:
        case ANONYMOUS_VARIABLE:
        case PLUS:
        case MINUS:
        case TIMES:
        case DIV:
        case MODULO:
        case PAREN_OPEN:
        case EQUAL:
        case UNEQUAL:
        case LESS:
        case GREATER:
        case LESS_OR_EQ:
        case GREATER_OR_EQ:
        case DLV_ARITHMETIC_ID:
        case DLV_ID:
        case CLINGO_ID:
          NAFLiteral();
          break;
        default:
          jj_la1[9] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * Return HeadElementsList
   * @return HeadElementsList
   * @throws ParseException HeadElementsList
   */
  final public ASTHeadElementsList Disjunction() throws ParseException {
 /*@bgen(jjtree) HeadElementsList */
  ASTHeadElementsList jjtn000 = new ASTHeadElementsList(JJTHEADELEMENTSLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      label_4:
      while (true) {
        if (jj_2_7(2147483647)) {
          ;
        } else {
          break label_4;
        }
        ClassicalLiteral();
        jj_consume_token(OR);
      }
      ClassicalLiteral();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * Return Choice
   * @return Choice
   * @throws ParseException Choise
   */
  final public ASTChoice Choice() throws ParseException {
 /*@bgen(jjtree) Choice */
  ASTChoice jjtn000 = new ASTChoice(JJTCHOICE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
      case VARIABLE:
      case STRING:
      case NUMBER:
      case ANONYMOUS_VARIABLE:
      case MINUS:
      case PAREN_OPEN:
        Term();
        Binop();
        break;
      default:
        jj_la1[10] = jj_gen;
        ;
      }
      jj_consume_token(CURLY_OPEN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
      case MINUS:
      case DLV_ID:
      case CLINGO_ID:
        ChoiceElements();
        break;
      default:
        jj_la1[11] = jj_gen;
        ;
      }
      jj_consume_token(CURLY_CLOSE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQUAL:
      case UNEQUAL:
      case LESS:
      case GREATER:
      case LESS_OR_EQ:
      case GREATER_OR_EQ:
        Binop();
        Term();
        break;
      default:
        jj_la1[12] = jj_gen;
        ;
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * Return ChoiceElementList
   * @return ChoiceElementList
   * @throws ParseException ChoiseElementList
   */
  final public ASTChoiceElementList ChoiceElements() throws ParseException {
 /*@bgen(jjtree) ChoiceElementList */
  ASTChoiceElementList jjtn000 = new ASTChoiceElementList(JJTCHOICEELEMENTLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      label_5:
      while (true) {
        if (jj_2_8(2147483647)) {
          ;
        } else {
          break label_5;
        }
        ChoiceElement();
        jj_consume_token(SEMICOLON);
      }
      ChoiceElement();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * Return ChoiceElement
   * @return ChoiceElement
   * @throws ParseException ChoiceElement
   */
  final public ASTChoiceElement ChoiceElement() throws ParseException {
 /*@bgen(jjtree) ChoiceElement */
  ASTChoiceElement jjtn000 = new ASTChoiceElement(JJTCHOICEELEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      ClassicalLiteral();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
        jj_consume_token(COLON);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NAF:
        case ID:
        case VARIABLE:
        case STRING:
        case NUMBER:
        case ANONYMOUS_VARIABLE:
        case PLUS:
        case MINUS:
        case TIMES:
        case DIV:
        case MODULO:
        case PAREN_OPEN:
        case EQUAL:
        case UNEQUAL:
        case LESS:
        case GREATER:
        case LESS_OR_EQ:
        case GREATER_OR_EQ:
        case DLV_ARITHMETIC_ID:
        case DLV_ID:
        case CLINGO_ID:
          NAFLiterals();
          break;
        default:
          jj_la1[13] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[14] = jj_gen;
        ;
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * Return Aggregate
   * @return Aggregate
   * @throws ParseException Aggregate
   */
  final public ASTAggregate Aggregate() throws ParseException {
 /*@bgen(jjtree) Aggregate */
  ASTAggregate jjtn000 = new ASTAggregate(JJTAGGREGATE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
      case VARIABLE:
      case STRING:
      case NUMBER:
      case ANONYMOUS_VARIABLE:
      case MINUS:
      case PAREN_OPEN:
        Term();
        Binop();
        break;
      default:
        jj_la1[15] = jj_gen;
        ;
      }
      AggregateFunction();
      jj_consume_token(CURLY_OPEN);
      AggregateElements();
      jj_consume_token(CURLY_CLOSE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQUAL:
      case UNEQUAL:
      case LESS:
      case GREATER:
      case LESS_OR_EQ:
      case GREATER_OR_EQ:
        Binop();
        Term();
        break;
      default:
        jj_la1[16] = jj_gen;
        ;
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * Return AggrElementList
   * @return AggrElementList
   * @throws ParseException AggrElementList
   */
  final public ASTAggrElementList AggregateElements() throws ParseException {
 /*@bgen(jjtree) AggrElementList */
  ASTAggrElementList jjtn000 = new ASTAggrElementList(JJTAGGRELEMENTLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      label_6:
      while (true) {
        if (jj_2_9(2147483647)) {
          ;
        } else {
          break label_6;
        }
        AggregateElement();
        jj_consume_token(SEMICOLON);
      }
      AggregateElement();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * Return AggrElement
   * @return AggrElement
   * @throws ParseException AggrElement
   */
  final public ASTAggrElement AggregateElement() throws ParseException {
 /*@bgen(jjtree) AggrElement */
  ASTAggrElement jjtn000 = new ASTAggrElement(JJTAGGRELEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
      case VARIABLE:
      case STRING:
      case NUMBER:
      case ANONYMOUS_VARIABLE:
      case MINUS:
      case PAREN_OPEN:
        Terms();
        break;
      default:
        jj_la1[17] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
        jj_consume_token(COLON);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NAF:
        case ID:
        case VARIABLE:
        case STRING:
        case NUMBER:
        case ANONYMOUS_VARIABLE:
        case PLUS:
        case MINUS:
        case TIMES:
        case DIV:
        case MODULO:
        case PAREN_OPEN:
        case EQUAL:
        case UNEQUAL:
        case LESS:
        case GREATER:
        case LESS_OR_EQ:
        case GREATER_OR_EQ:
        case DLV_ARITHMETIC_ID:
        case DLV_ID:
        case CLINGO_ID:
          NAFLiterals();
          break;
        default:
          jj_la1[18] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[19] = jj_gen;
        ;
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * Return AggrFunc
   * @return AggrFunc
   * @throws ParseException AggrFunc
   */
  final public String AggregateFunction() throws ParseException {
 /*@bgen(jjtree) AggrFunc */
  ASTAggrFunc jjtn000 = new ASTAggrFunc(JJTAGGRFUNC);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AGGREGATE_COUNT:
        jj_consume_token(AGGREGATE_COUNT);
        break;
      case AGGREGATE_MAX:
        jj_consume_token(AGGREGATE_MAX);
        break;
      case AGGREGATE_MIN:
        jj_consume_token(AGGREGATE_MIN);
        break;
      case AGGREGATE_SUM_PLUS:
        jj_consume_token(AGGREGATE_SUM_PLUS);
        break;
      case AGGREGATE_SUM:
        jj_consume_token(AGGREGATE_SUM);
        break;
      case AGGREGATE_TIMES:
        jj_consume_token(AGGREGATE_TIMES);
        break;
      default:
        jj_la1[20] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
        jjtn000.func(this.token.image);
        {if (true) return this.token.image;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * @throws ParseException ClingoMeta
   */
  final public void MetaStatement() throws ParseException {
 /*@bgen(jjtree) ClingoMeta */
  ASTClingoMeta jjtn000 = new ASTClingoMeta(JJTCLINGOMETA);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CLINGO_SHOW:
        jj_consume_token(CLINGO_SHOW);
        break;
      case META_MAXINT:
        jj_consume_token(META_MAXINT);
        break;
      case META_CONST:
        jj_consume_token(META_CONST);
        break;
      case META_OTHER:
        jj_consume_token(META_OTHER);
        break;
      default:
        jj_la1[21] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
         jjtn000.statement(this.token.image);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  /**
   *
   * @return Opt
   * @throws ParseException Opt
   */
  final public ASTOpt Optimize() throws ParseException {
 /*@bgen(jjtree) Opt */
  ASTOpt jjtn000 = new ASTOpt(JJTOPT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      OptimizeFunction();
      jj_consume_token(CURLY_OPEN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
      case VARIABLE:
      case STRING:
      case NUMBER:
      case ANONYMOUS_VARIABLE:
      case MINUS:
      case PAREN_OPEN:
        OptimizeElements();
        break;
      default:
        jj_la1[22] = jj_gen;
        ;
      }
      jj_consume_token(CURLY_CLOSE);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * @return OptElementList
   * @throws ParseException OptElementList
   */
  final public ASTOptElementList OptimizeElements() throws ParseException {
 /*@bgen(jjtree) OptElementList */
  ASTOptElementList jjtn000 = new ASTOptElementList(JJTOPTELEMENTLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      label_7:
      while (true) {
        if (jj_2_10(2147483647)) {
          ;
        } else {
          break label_7;
        }
        OptimizeElement();
        jj_consume_token(SEMICOLON);
      }
      OptimizeElement();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * @return OptElement
   * @throws ParseException OptElement
   */
  final public ASTOptElement OptimizeElement() throws ParseException {
 /*@bgen(jjtree) OptElement */
  ASTOptElement jjtn000 = new ASTOptElement(JJTOPTELEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      WeightAtLevel();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
        jj_consume_token(COLON);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NAF:
        case ID:
        case VARIABLE:
        case STRING:
        case NUMBER:
        case ANONYMOUS_VARIABLE:
        case PLUS:
        case MINUS:
        case TIMES:
        case DIV:
        case MODULO:
        case PAREN_OPEN:
        case EQUAL:
        case UNEQUAL:
        case LESS:
        case GREATER:
        case LESS_OR_EQ:
        case GREATER_OR_EQ:
        case DLV_ARITHMETIC_ID:
        case DLV_ID:
        case CLINGO_ID:
          NAFLiterals();
          break;
        default:
          jj_la1[23] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[24] = jj_gen;
        ;
      }
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * @return OptFunc
   * @throws ParseException OptFunc
   */
  final public String OptimizeFunction() throws ParseException {
 /*@bgen(jjtree) OptFunc */
  ASTOptFunc jjtn000 = new ASTOptFunc(JJTOPTFUNC);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MAXIMIZE:
        jj_consume_token(MAXIMIZE);
                 jjtn000.maximize(true);
        break;
      case MINIMIZE:
        jj_consume_token(MINIMIZE);
        break;
      default:
        jj_la1[25] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
        jjtn000.func(this.token.image);
        {if (true) return this.token.image;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * @return Weight
   * @throws ParseException Weight
   */
  final public ASTWeight WeightAtLevel() throws ParseException {
 /*@bgen(jjtree) Weight */
  ASTWeight jjtn000 = new ASTWeight(JJTWEIGHT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      Term();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AT:
        jj_consume_token(AT);
        Term();
                          jjtn000.hasLevel(true);
        break;
      default:
        jj_la1[26] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        Terms();
        break;
      default:
        jj_la1[27] = jj_gen;
        ;
      }
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * @return NAFLiteralList
   * @throws ParseException NAFLiteralList
   */
  final public ASTNAFLiteralList NAFLiterals() throws ParseException {
 /*@bgen(jjtree) NAFLiteralList */
  ASTNAFLiteralList jjtn000 = new ASTNAFLiteralList(JJTNAFLITERALLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      label_8:
      while (true) {
        if (jj_2_11(2147483647)) {
          ;
        } else {
          break label_8;
        }
        NAFLiteral();
        jj_consume_token(COMMA);
      }
      NAFLiteral();
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * @return ASTNAFLiteral
   * @throws ParseException ASTNAFLiteral
   */
  final public ASTNAFLiteral NAFLiteral() throws ParseException {
 /*@bgen(jjtree) NAFLiteral */
  ASTNAFLiteral jjtn000 = new ASTNAFLiteral(JJTNAFLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NAF:
        jj_consume_token(NAF);
          jjtn000.nafneg(true);
        break;
      default:
        jj_la1[28] = jj_gen;
        ;
      }
      if (jj_2_12(2147483647)) {
        BuiltinAtom();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ID:
        case MINUS:
        case DLV_ID:
        case CLINGO_ID:
          ClassicalLiteral();
          break;
        default:
          jj_la1[29] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
   if (jjtc000) {
     jjtree.clearNodeScope(jjtn000);
     jjtc000 = false;
   } else {
     jjtree.popNode();
   }
   if (jjte000 instanceof RuntimeException) {
     {if (true) throw (RuntimeException)jjte000;}
   }
   if (jjte000 instanceof ParseException) {
     {if (true) throw (ParseException)jjte000;}
   }
   {if (true) throw (Error)jjte000;}
    } finally {
   if (jjtc000) {
     jjtree.closeNodeScope(jjtn000, true);
   }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * @return ASTLiteral
   * @throws ParseException ASTListeral
   */
  final public ASTLiteral ClassicalLiteral() throws ParseException {
 /*@bgen(jjtree) Literal */
  ASTLiteral jjtn000 = new ASTLiteral(JJTLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
        jj_consume_token(MINUS);
            jjtn000.neg(true);
        break;
      default:
        jj_la1[30] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
        Identifier();
        break;
      case DLV_ID:
        DlvIdentifier();
        break;
      case CLINGO_ID:
        ClingoIdentifier();
        break;
      default:
        jj_la1[31] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PAREN_OPEN:
        jj_consume_token(PAREN_OPEN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ID:
        case VARIABLE:
        case STRING:
        case NUMBER:
        case ANONYMOUS_VARIABLE:
        case MINUS:
        case PAREN_OPEN:
          Terms();
          break;
        default:
          jj_la1[32] = jj_gen;
          ;
        }
        jj_consume_token(PAREN_CLOSE);
        break;
      default:
        jj_la1[33] = jj_gen;
        ;
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * @return ASTBuiltInAtom
   * @throws ParseException ASTBuiltInAtom
   */
  final public ASTBuiltInAtom BuiltinAtom() throws ParseException {
 /*@bgen(jjtree) BuiltInAtom */
  ASTBuiltInAtom jjtn000 = new ASTBuiltInAtom(JJTBUILTINATOM);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      if (jj_2_13(4)) {
        Term();
        Binop();
        Term();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EQUAL:
        case UNEQUAL:
        case LESS:
        case GREATER:
        case LESS_OR_EQ:
        case GREATER_OR_EQ:
          Binop();
          jj_consume_token(PAREN_OPEN);
          Term();
          jj_consume_token(COMMA);
          Term();
          jj_consume_token(PAREN_CLOSE);
          break;
        case DLV_ARITHMETIC_ID:
          DlvArithmeticPredicate();
          jj_consume_token(PAREN_OPEN);
          Terms();
          jj_consume_token(PAREN_CLOSE);
          break;
        case PLUS:
        case MINUS:
        case TIMES:
        case DIV:
        case MODULO:
          Arithop();
          jj_consume_token(PAREN_OPEN);
          Term();
          jj_consume_token(COMMA);
          Term();
          jj_consume_token(COMMA);
          Term();
          jj_consume_token(PAREN_CLOSE);
          break;
        default:
          jj_la1[34] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * @return Binop
   * @throws ParseException Binop
   */
  final public String Binop() throws ParseException {
 /*@bgen(jjtree) Binop */
  ASTBinop jjtn000 = new ASTBinop(JJTBINOP);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQUAL:
        jj_consume_token(EQUAL);
        break;
      case UNEQUAL:
        jj_consume_token(UNEQUAL);
        break;
      case LESS:
        jj_consume_token(LESS);
        break;
      case GREATER:
        jj_consume_token(GREATER);
        break;
      case LESS_OR_EQ:
        jj_consume_token(LESS_OR_EQ);
        break;
      case GREATER_OR_EQ:
        jj_consume_token(GREATER_OR_EQ);
        break;
      default:
        jj_la1[35] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
        jjtn000.op(this.token.image);
        {if (true) return this.token.image;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * @return ASTTermList
   * @throws ParseException ASTTermList
   */
  final public ASTTermList Terms() throws ParseException {
 /*@bgen(jjtree) TermList */
  ASTTermList jjtn000 = new ASTTermList(JJTTERMLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      label_9:
      while (true) {
        if (jj_2_14(2147483647)) {
          ;
        } else {
          break label_9;
        }
        Term();
        jj_consume_token(COMMA);
      }
      Term();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * @return ASTTerm
   * @throws ParseException ASTTerm
   */
  final public ASTTerm Term() throws ParseException {
 /*@bgen(jjtree) Term */
  ASTTerm jjtn000 = new ASTTerm(JJTTERM);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
        Identifier();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PAREN_OPEN:
          jj_consume_token(PAREN_OPEN);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ID:
          case VARIABLE:
          case STRING:
          case NUMBER:
          case ANONYMOUS_VARIABLE:
          case MINUS:
          case PAREN_OPEN:
            Terms();
            break;
          default:
            jj_la1[36] = jj_gen;
            ;
          }
          jj_consume_token(PAREN_CLOSE);
          break;
        default:
          jj_la1[37] = jj_gen;
          ;
        }
        AriTerm();
        break;
      case NUMBER:
        Number();
        AriTerm();
        break;
      case STRING:
        String();
        AriTerm();
        break;
      case VARIABLE:
      case ANONYMOUS_VARIABLE:
        Variable();
        AriTerm();
        break;
      case PAREN_OPEN:
        jj_consume_token(PAREN_OPEN);
        Term();
        jj_consume_token(PAREN_CLOSE);
        AriTerm();
        break;
      case MINUS:
        jj_consume_token(MINUS);
              jjtn000.neg(true);
        Term();
        AriTerm();
        break;
      default:
        jj_la1[38] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * @return Ariterm
   * @throws ParseException Ariterm
   */
  final public ASTAriTerm AriTerm() throws ParseException {
 /*@bgen(jjtree) AriTerm */
  ASTAriTerm jjtn000 = new ASTAriTerm(JJTARITERM);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);String t = "";
    try {
      if (jj_2_15(2)) {
        t = Arithop();
        Term();
      } else {
        ;
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
  jjtn000.op(t);
  {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * @return Arithop
   * @throws ParseException Arithop
   */
  final public String Arithop() throws ParseException {
 /*@bgen(jjtree) Arithop */
  ASTArithop jjtn000 = new ASTArithop(JJTARITHOP);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
        break;
      case MINUS:
        jj_consume_token(MINUS);
        break;
      case TIMES:
        jj_consume_token(TIMES);
        break;
      case DIV:
        jj_consume_token(DIV);
        break;
      case MODULO:
        jj_consume_token(MODULO);
        break;
      default:
        jj_la1[39] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.op(this.token.image);
        {if (true) return this.token.image;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  /**
   *
   * @throws ParseException ParseException
   */
  final public void Number() throws ParseException {
 /*@bgen(jjtree) Number */
        ASTNumber jjtn000 = new ASTNumber(JJTNUMBER);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(NUMBER);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          jjtn000.number(t.image);
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
  }

  /**
   *
   * @throws ParseException ParseException
   */
  final public void Variable() throws ParseException {
 /*@bgen(jjtree) Var */
  ASTVar jjtn000 = new ASTVar(JJTVAR);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VARIABLE:
        t = jj_consume_token(VARIABLE);
        break;
      case ANONYMOUS_VARIABLE:
        t = jj_consume_token(ANONYMOUS_VARIABLE);
        break;
      default:
        jj_la1[40] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.name(t.image);
    } finally {
   if (jjtc000) {
     jjtree.closeNodeScope(jjtn000, true);
   }
    }
  }

  /**
   *
   * @throws ParseException Identifier
   */
  final public void Identifier() throws ParseException {
 /*@bgen(jjtree) ID */
        ASTID jjtn000 = new ASTID(JJTID);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(ID);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.name(t.image);
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
  }

  /**
   *
   * @throws ParseException DlvIdentifier
   */
  final public void DlvIdentifier() throws ParseException {
 /*@bgen(jjtree) DlvID */
        ASTDlvID jjtn000 = new ASTDlvID(JJTDLVID);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(DLV_ID);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.name(t.image);
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
  }

  /**
   *
   * @throws ParseException Parse Exception
   */
  final public void ClingoIdentifier() throws ParseException {
 /*@bgen(jjtree) ClingoID */
        ASTClingoID jjtn000 = new ASTClingoID(JJTCLINGOID);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(CLINGO_ID);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.name(t.image);
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
  }

  /**
   *
   * @throws ParseException ParseException
   */
  final public void DlvArithmeticPredicate() throws ParseException {
 /*@bgen(jjtree) DlvArithmeticID */
        ASTDlvArithmeticID jjtn000 = new ASTDlvArithmeticID(JJTDLVARITHMETICID);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(DLV_ARITHMETIC_ID);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.name(t.image);
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
  }

  /**
   *
   * @throws ParseException ParseException
   */
  final public void String() throws ParseException {
 /*@bgen(jjtree) String */
        ASTString jjtn000 = new ASTString(JJTSTRING);
        boolean jjtc000 = true;
        jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(STRING);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.name(t.image);
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_3R_32() {
    if (jj_3R_65()) return true;
    if (jj_scan_token(CURLY_OPEN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_66()) jj_scanpos = xsp;
    if (jj_scan_token(CURLY_CLOSE)) return true;
    return false;
  }

  private boolean jj_3R_75() {
    if (jj_scan_token(DLV_ID)) return true;
    return false;
  }

  private boolean jj_3R_70() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_106() {
    if (jj_3R_29()) return true;
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_79() {
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3R_74() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_48() {
    if (jj_scan_token(COLON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_79()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_27() {
    if (jj_3R_30()) return true;
    if (jj_scan_token(PAREN_OPEN)) return true;
    if (jj_3R_28()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_77() {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_16() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_78() {
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3_9() {
    if (jj_3R_21()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_47() {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_21() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_47()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_48()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_89() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) return true;
    }
    return false;
  }

  private boolean jj_3R_87() {
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_98() {
    if (jj_3R_29()) return true;
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_46() {
    if (jj_scan_token(COLON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_78()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_45() {
    if (jj_scan_token(PAREN_OPEN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_77()) jj_scanpos = xsp;
    if (jj_scan_token(PAREN_CLOSE)) return true;
    return false;
  }

  private boolean jj_3R_72() {
    if (jj_scan_token(NAF)) return true;
    return false;
  }

  private boolean jj_3R_110() {
    if (jj_3R_21()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_97() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_110()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_21()) return true;
    return false;
  }

  private boolean jj_3R_105() {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_103() {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_96() {
    if (jj_3R_28()) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_73() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_96()) jj_scanpos = xsp;
    if (jj_3R_16()) return true;
    if (jj_scan_token(CURLY_OPEN)) return true;
    if (jj_3R_97()) return true;
    if (jj_scan_token(CURLY_CLOSE)) return true;
    xsp = jj_scanpos;
    if (jj_3R_98()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_8() {
    if (jj_3R_20()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_30() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_20() {
    if (jj_3R_19()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_46()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_44() {
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_85() {
    if (jj_scan_token(PAREN_OPEN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_103()) jj_scanpos = xsp;
    if (jj_scan_token(PAREN_CLOSE)) return true;
    return false;
  }

  private boolean jj_3_15() {
    if (jj_3R_30()) return true;
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_3R_20()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_86() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_15()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_38() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_71()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3R_61() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_28()) return true;
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_3R_19()) return true;
    if (jj_scan_token(OR)) return true;
    return false;
  }

  private boolean jj_3R_60() {
    if (jj_scan_token(PAREN_OPEN)) return true;
    if (jj_3R_28()) return true;
    if (jj_scan_token(PAREN_CLOSE)) return true;
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_104() {
    if (jj_3R_28()) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_14() {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_3R_89()) return true;
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_58() {
    if (jj_3R_88()) return true;
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_90() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_104()) jj_scanpos = xsp;
    if (jj_scan_token(CURLY_OPEN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_105()) jj_scanpos = xsp;
    if (jj_scan_token(CURLY_CLOSE)) return true;
    xsp = jj_scanpos;
    if (jj_3R_106()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_18() {
    if (jj_3R_28()) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_14() {
    if (jj_3R_28()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_43() {
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_57() {
    if (jj_3R_87()) return true;
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_56() {
    if (jj_3R_74()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_85()) jj_scanpos = xsp;
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_28() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) {
    jj_scanpos = xsp;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) {
    jj_scanpos = xsp;
    if (jj_3R_61()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_107() {
    if (jj_3R_19()) return true;
    if (jj_scan_token(OR)) return true;
    return false;
  }

  private boolean jj_3R_91() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_107()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3_6() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(7)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_18()) jj_scanpos = xsp;
    if (jj_3R_16()) return true;
    return false;
  }

  private boolean jj_3R_26() {
    if (jj_3R_54()) return true;
    if (jj_scan_token(PAREN_OPEN)) return true;
    if (jj_3R_55()) return true;
    if (jj_scan_token(PAREN_CLOSE)) return true;
    return false;
  }

  private boolean jj_3R_84() {
    if (jj_3R_28()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_55() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_84()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_42() {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3_5() {
    if (jj_3R_17()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_40() {
    if (jj_3R_23()) return true;
    return false;
  }

  private boolean jj_3R_39() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_72()) jj_scanpos = xsp;
    if (jj_3R_73()) return true;
    return false;
  }

  private boolean jj_3R_17() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_39()) {
    jj_scanpos = xsp;
    if (jj_3R_40()) return true;
    }
    return false;
  }

  private boolean jj_3R_25() {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_81() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_15() {
    if (jj_3R_28()) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_109() {
    if (jj_3R_17()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3_4() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_15()) jj_scanpos = xsp;
    if (jj_3R_16()) return true;
    if (jj_scan_token(CURLY_OPEN)) return true;
    return false;
  }

  private boolean jj_3R_94() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_109()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_17()) return true;
    return false;
  }

  private boolean jj_3R_13() {
    if (jj_3R_28()) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_29() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_3() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_13()) jj_scanpos = xsp;
    if (jj_scan_token(CURLY_OPEN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_14()) jj_scanpos = xsp;
    if (jj_scan_token(CURLY_CLOSE)) return true;
    return false;
  }

  private boolean jj_3R_95() {
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3R_102() {
    if (jj_3R_30()) return true;
    if (jj_scan_token(PAREN_OPEN)) return true;
    if (jj_3R_28()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_28()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_28()) return true;
    if (jj_scan_token(PAREN_CLOSE)) return true;
    return false;
  }

  private boolean jj_3R_11() {
    if (jj_3R_32()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_101() {
    if (jj_3R_54()) return true;
    if (jj_scan_token(PAREN_OPEN)) return true;
    if (jj_3R_55()) return true;
    if (jj_scan_token(PAREN_CLOSE)) return true;
    return false;
  }

  private boolean jj_3R_64() {
    if (jj_3R_91()) return true;
    return false;
  }

  private boolean jj_3R_100() {
    if (jj_3R_29()) return true;
    if (jj_scan_token(PAREN_OPEN)) return true;
    if (jj_3R_28()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_28()) return true;
    if (jj_scan_token(PAREN_CLOSE)) return true;
    return false;
  }

  private boolean jj_3R_63() {
    if (jj_3R_73()) return true;
    return false;
  }

  private boolean jj_3R_69() {
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3_13() {
    if (jj_3R_28()) return true;
    if (jj_3R_29()) return true;
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_83() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3R_100()) {
    jj_scanpos = xsp;
    if (jj_3R_101()) {
    jj_scanpos = xsp;
    if (jj_3R_102()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_31() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_62()) {
    jj_scanpos = xsp;
    if (jj_3R_63()) {
    jj_scanpos = xsp;
    if (jj_3R_64()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_68() {
    if (jj_scan_token(CONS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_95()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_10() {
    if (jj_3R_31()) return true;
    return false;
  }

  private boolean jj_3R_67() {
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3R_37() {
    if (jj_3R_70()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_24() {
    if (jj_3R_28()) return true;
    if (jj_3R_29()) return true;
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3_12() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_24()) {
    jj_scanpos = xsp;
    if (jj_3R_25()) {
    jj_scanpos = xsp;
    if (jj_3R_26()) {
    jj_scanpos = xsp;
    if (jj_3R_27()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_41() {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_36() {
    if (jj_3R_32()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_35() {
    if (jj_scan_token(WCONS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_69()) jj_scanpos = xsp;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(SQUARE_OPEN)) return true;
    if (jj_3R_49()) return true;
    if (jj_scan_token(SQUARE_CLOSE)) return true;
    return false;
  }

  private boolean jj_3R_19() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_41()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_45()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_34() {
    if (jj_3R_31()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_68()) jj_scanpos = xsp;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_33() {
    if (jj_scan_token(CONS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_67()) jj_scanpos = xsp;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_12() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_53() {
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_12()) return true;
    return false;
  }

  private boolean jj_3_11() {
    if (jj_3R_23()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_51() {
    if (jj_scan_token(NAF)) return true;
    return false;
  }

  private boolean jj_3R_52() {
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_23() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_51()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_52()) {
    jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    }
    return false;
  }

  private boolean jj_3_1() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_3R_10()) {
    jj_scanpos = xsp;
    if (jj_3R_11()) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_80() {
    if (jj_scan_token(AT)) return true;
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_82() {
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3R_111() {
    if (jj_3R_23()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_99() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_111()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_23()) return true;
    return false;
  }

  private boolean jj_3R_49() {
    if (jj_3R_28()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_80()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_81()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_50() {
    if (jj_scan_token(COLON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_82()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_66() {
    if (jj_3R_93()) return true;
    return false;
  }

  private boolean jj_3R_92() {
    if (jj_scan_token(MAXIMIZE)) return true;
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_65() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) return true;
    }
    return false;
  }

  private boolean jj_3_10() {
    if (jj_3R_22()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_22() {
    if (jj_3R_49()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_50()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_54() {
    if (jj_scan_token(DLV_ARITHMETIC_ID)) return true;
    return false;
  }

  private boolean jj_3R_108() {
    if (jj_3R_22()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_93() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_108()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_22()) return true;
    return false;
  }

  private boolean jj_3R_76() {
    if (jj_scan_token(CLINGO_ID)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public ASPParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[41];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x400200,0x400200,0xbe03e80,0xbe03e80,0x80000,0xbe03e80,0x88583e00,0x400200,0x80,0xbe03e80,0x8403e00,0x400200,0x0,0xbe03e80,0x20000,0x8403e00,0x0,0x8403e00,0xbe03e80,0x20000,0x0,0x0,0x8403e00,0xbe03e80,0x20000,0x0,0x4000000,0x8000,0x80,0x400200,0x400000,0x200,0x8403e00,0x8000000,0x3e00000,0x0,0x8403e00,0x8000000,0x8403e00,0x3e00000,0x2400,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x180000,0x180000,0x1c73fe,0x1c73fe,0x0,0x1c73fe,0x3bff80,0x180000,0x0,0x1c007e,0x0,0x180000,0x7e,0x1c007e,0x0,0x0,0x7e,0x0,0x1c007e,0x0,0x7380,0x238000,0x0,0x1c007e,0x0,0xc00,0x0,0x0,0x0,0x180000,0x0,0x180000,0x0,0x0,0x4007e,0x7e,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[15];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream
   *
   * @param stream InputStream
   */
  public ASPParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding
   *
   * @param stream encoding
   * @param encoding encoding
   */
  public ASPParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new ASPParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  /**
   *
   * @param stream java.io.Input.Stream
   */

  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  /**
   *
   * @param stream java.io.InputStream
   * @param encoding java.io.InputStream
   */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor
   *
   * @param stream java.io.Reader
   */
  public ASPParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ASPParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  /**
   *
   * @param stream java.io.Reader
   */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager
   *
   * @param tm ASPParser TokenManager
   */
  public ASPParser(ASPParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  /**
   *
   * @param tm ReInit
   */
  public void ReInit(ASPParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  /**
   *
   * @return getNextToken
   */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  /**
   *
   * @param index getToken
   * @return getToken
   */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        exists = true;
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.add(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  /**
   *
   * @return generateParseException
   */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[54];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 41; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 54; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 15; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
