/*
 *  This file is part of "TweetyProject", a collection of Java libraries for
 *  logical aspects of artificial intelligence and knowledge representation.
 *
 *  TweetyProject is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version 3 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 *  Copyright 2016 The TweetyProject Team <http://tweetyproject.org/contact/>
 */
/* Generated By:JavaCC: Do not edit this line. UPParser.java */
package org.tweetyproject.preferences.io;
import java.util.*;
import org.tweetyproject.preferences.*;

import org.tweetyproject.preferences.update.Update;
import org.tweetyproject.preferences.Operation;

/**
Update Parser for reading updates for dynamic Preference Aggregation
Please note: update file syntax changed from
(index, operation, amount, element)
e.g. (1, WEAKEN, 2, a)
to
(index, operation(amount), element)
e.g. (1, -2, a)
where
-(/+) is equal to WEAKEN(/STRENGTHEN)
and 2 is the amount
*/
@SuppressWarnings("all")
public class UPParser implements UPParserConstants {
  /**
   * Constructor
   * */
  public UPParser()
        {

        }


/**
 * Parses the specified update file to extract a list of updates.
 *
 * @param updatefile The path to the update file to be parsed.
 * @return A list of {@link Update} objects containing the parsed updates.
 * @throws ParseException If an error occurs during the parsing process.
 * @throws java.io.FileNotFoundException If the specified file cannot be found.
 */
  public static ArrayList<Update < String >> parse(String updatefile) throws ParseException, java.io.FileNotFoundException
  {
    UPParser parser;
    parser = new UPParser(new java.io.FileInputStream(updatefile));
    return parser.getUpdate();
  }

  /**
   * Example
   * @param args the args
   * @throws ParseException error
   */
  public static void main(String args []) throws ParseException
  {
    try
    {
                ArrayList<Update <String >> testUP = new ArrayList<Update <String >>();
                testUP = parse("/home/bwolf/Universit\u00e4t/Tweety/tweety-code/projects/org-tweetyproject-preferences/src/main/java/org.tweetyproject/preferences/io/test.up");
                System.out.println(testUP);
    }
    catch (Exception e)
    {
      System.out.println("error while parsing: ");
      e.printStackTrace();
    }
  }

  /**
   *
   * Return update
   * @return update
   * @throws ParseException error
   * @throws java.io.FileNotFoundException error
   */
  final public ArrayList<Update < String > > getUpdate() throws ParseException, java.io.FileNotFoundException {
  Token index, op, element;
  ArrayList < Update < String >> updates = new ArrayList < Update < String >> ();
    label_1:
    while (true) {
      jj_consume_token(LBRA);
      index = jj_consume_token(INDEX);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 8:
        jj_consume_token(8);
        break;
      default:
        jj_la1[0] = jj_gen;
        ;
      }
      op = jj_consume_token(OPERATION);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 8:
        jj_consume_token(8);
        break;
      default:
        jj_la1[1] = jj_gen;
        ;
      }
      element = jj_consume_token(ELEMENT);
                Integer ind = Integer.parseInt(index.image);

        // finding element to perform update on
        String elm = element.image;
        Integer amnt = Integer.parseInt(op.image.substring(1));

        if (op.image.startsWith("-"))
        {
          Update < String > tmp = new Update<String >(ind, Operation.WEAKEN, amnt, elm);
          updates.add(tmp);
        }
        else if (op.image.startsWith("+"))
        {
          Update < String > tmp = new Update<String >(ind, Operation.STRENGTHEN, amnt, elm);
          updates.add(tmp);
        }
        else
        {
          continue;
        }
      jj_consume_token(RBRA);
      jj_consume_token(EOL);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRA:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_1;
      }
    }
    {if (true) return updates;}
    throw new Error("Missing return statement in function");
  }

  /** Generated Token Manager. */
  public UPParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[3];
  static private int[] jj_la1_0;
  static {
      jj_la1_init_0();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x100,0x100,0x4,};
   }

  /** Constructor with InputStream.
   *
   * @param stream input stream
   */
  public UPParser(java.io.InputStream stream) {
     this(stream, null);
  }
 /**
     * Constructs a parser with an input stream and a specified encoding.
     *
     * @param stream   The input stream to read from.
     * @param encoding The character encoding of the input stream.
     * @throws RuntimeException If the specified encoding is unsupported.
     */
    public UPParser(java.io.InputStream stream, String encoding) {
      try {
          jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
      } catch (java.io.UnsupportedEncodingException e) {
          throw new RuntimeException(e);
      }
      token_source = new UPParserTokenManager(jj_input_stream);
      token = new Token();
      jj_ntk = -1;
      jj_gen = 0;
      for (int i = 0; i < 3; i++) jj_la1[i] = -1;
  }




  /**
   * Reinitializes the parser with a new input stream and a specified encoding.
   *
   * @param stream   The new input stream to read from.
   * @param encoding The character encoding of the new input stream.
   * @throws RuntimeException If the specified encoding is unsupported.
   */
  public void ReInit(java.io.InputStream stream, String encoding) {
      try {
          jj_input_stream.ReInit(stream, encoding, 1, 1);
      } catch (java.io.UnsupportedEncodingException e) {
          throw new RuntimeException(e);
      }
      token_source.ReInit(jj_input_stream);
      token = new Token();
      jj_ntk = -1;
      jj_gen = 0;
      for (int i = 0; i < 3; i++) jj_la1[i] = -1;
  }

  /**
   * Reinitializes the parser with a new input stream using the default encoding.
   *
   * @param stream The new input stream to read from.
   */
  public void ReInit(java.io.InputStream stream) {
      ReInit(stream, null);
  }

  /**
   * Constructs a parser with a reader.
   *
   * @param stream The reader to read from.
   */
  public UPParser(java.io.Reader stream) {
      jj_input_stream = new SimpleCharStream(stream, 1, 1);
      token_source = new UPParserTokenManager(jj_input_stream);
      token = new Token();
      jj_ntk = -1;
      jj_gen = 0;
      for (int i = 0; i < 3; i++) jj_la1[i] = -1;
  }

  /**
   * Reinitializes the parser with a new reader.
   *
   * @param stream The new reader to read from.
   */
  public void ReInit(java.io.Reader stream) {
      jj_input_stream.ReInit(stream, 1, 1);
      token_source.ReInit(jj_input_stream);
      token = new Token();
      jj_ntk = -1;
      jj_gen = 0;
      for (int i = 0; i < 3; i++) jj_la1[i] = -1;
  }

  /**
   * Constructs a parser with a provided token manager.
   *
   * @param tm The token manager to use for token processing.
   */
  public UPParser(UPParserTokenManager tm) {
      token_source = tm;
      token = new Token();
      jj_ntk = -1;
      jj_gen = 0;
      for (int i = 0; i < 3; i++) jj_la1[i] = -1;
  }

  /**
   * Reinitializes the parser with a new token manager.
   *
   * @param tm The new token manager to use for token processing.
   */
  public void ReInit(UPParserTokenManager tm) {
      token_source = tm;
      token = new Token();
      jj_ntk = -1;
      jj_gen = 0;
      for (int i = 0; i < 3; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token.
 * @return next token
 */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token
 *
 * @param index the index
 * @return a token
 */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);

    }
  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException.
   * @return ParseException
  */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[9];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 3; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 9; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
