/*
 *  This file is part of "TweetyProject", a collection of Java libraries for
 *  logical aspects of artificial intelligence and knowledge representation.
 *
 *  TweetyProject is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version 3 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 *  Copyright 2016 The TweetyProject Team <http://tweetyproject.org/contact/>
 */
/* Generated By:JavaCC: Do not edit this line. TokenMgrError.java Version 5.0 */
/* JavaCCOptions: */
package org.tweetyproject.preferences.io;

/** Token Manager Error. */
public class TokenMgrError extends Error
{

  /**
   * The version identifier for this Serializable class.
   * Increment only if the <i>serialized</i> form of the
   * class changes.
   */
  private static final long serialVersionUID = 1L;

  /*
   * Ordinals for various reasons why an Error of this type can be thrown.
   */

  /**
   * Lexical error occurred.
   */
  static final int LEXICAL_ERROR = 0;

  /**
   * An attempt was made to create a second instance of a static token manager.
   */
  static final int STATIC_LEXER_ERROR = 1;

  /**
   * Tried to change to an invalid lexical state.
   */
  static final int INVALID_LEXICAL_STATE = 2;

  /**
   * Detected (and bailed out of) an infinite loop in the token manager.
   */
  static final int LOOP_DETECTED = 3;

  /**
   * Indicates the reason why the exception is thrown. It will have
   * one of the above 4 values.
   */
  int errorCode;

  /**
     * Replaces unprintable characters in the given string with their escaped
     * or unicode escaped equivalents.
     *
     * @param str the input string to process.
     * @return a new string with unprintable characters replaced by their escaped equivalents.
     */
    protected static final String addEscapes(String str) {
      StringBuffer retval = new StringBuffer();
      char ch;
      for (int i = 0; i < str.length(); i++) {
          switch (str.charAt(i)) {
              case 0:
                  continue;
              case '\b':
                  retval.append("\\b");
                  continue;
              case '\t':
                  retval.append("\\t");
                  continue;
              case '\n':
                  retval.append("\\n");
                  continue;
              case '\f':
                  retval.append("\\f");
                  continue;
              case '\r':
                  retval.append("\\r");
                  continue;
              case '\"':
                  retval.append("\\\"");
                  continue;
              case '\'':
                  retval.append("\\\'");
                  continue;
              case '\\':
                  retval.append("\\\\");
                  continue;
              default:
                  if ((ch = str.charAt(i)) < 0x20 || ch > 0x7e) {
                      String s = "0000" + Integer.toString(ch, 16);
                      retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                  } else {
                      retval.append(ch);
                  }
                  continue;
          }
      }
      return retval.toString();
  }

  /**
   * Generates a detailed message for a lexical error encountered by the token manager.
   *
   * <p>
   * This method can be customized to modify the format or content of the error message.
   * </p>
   *
   * @param EOFSeen indicates if the end of file (EOF) caused the lexical error.
   * @param lexState the lexical state in which the error occurred.
   * @param errorLine the line number where the error occurred.
   * @param errorColumn the column number where the error occurred.
   * @param errorAfter the string that was seen before this error occurred.
   * @param curChar the offending character that caused the error.
   * @return a detailed error message describing the lexical error.
   */
  protected static String LexicalError(boolean EOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, char curChar) {
      return ("Lexical error at line " +
              errorLine + ", column " +
              errorColumn + ".  Encountered: " +
              (EOFSeen ? "<EOF> " : ("\"" + addEscapes(String.valueOf(curChar)) + "\"") + " (" + (int)curChar + "), ") +
              "after : \"" + addEscapes(errorAfter) + "\"");
  }

  /**
   * Returns a detailed message about the error. This method can be customized to
   * change the content of error messages, especially for internal errors.
   *
   * @return the error message as a string.
   */
  @Override
  public String getMessage() {
      return super.getMessage();
  }

  /** No-argument constructor for {@code TokenMgrError}. */
  public TokenMgrError() {
  }

  /**
   * Constructor for {@code TokenMgrError} with a specified message and reason code.
   *
   * @param message the detailed error message.
   * @param reason the reason code indicating the type of error.
   */
  public TokenMgrError(String message, int reason) {
      super(message);
      this.errorCode = reason;
  }

  /**
   * Full constructor for {@code TokenMgrError}, generating a detailed lexical error message.
   *
   * @param EOFSeen indicates if the end of file (EOF) caused the lexical error.
   * @param lexState the lexical state in which the error occurred.
   * @param errorLine the line number where the error occurred.
   * @param errorColumn the column number where the error occurred.
   * @param errorAfter the string that was seen before this error occurred.
   * @param curChar the offending character that caused the error.
   * @param reason the reason code indicating the type of error.
   */
  public TokenMgrError(boolean EOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, char curChar, int reason) {
      this(LexicalError(EOFSeen, lexState, errorLine, errorColumn, errorAfter, curChar), reason);
  }
}
/* JavaCC - OriginalChecksum=d486d74a96e581d77ca973bf160fa544 (do not edit this line) */
