/** Generated By:JavaCC: Do not edit this line. SimpleCharStream.java Version 5.0 */
/** JavaCCOptions:STATIC=false,SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
package org.tweetyproject.arg.delp.parser;

/**
 * An implementation of interface CharStream, where the stream is assumed to
 * contain only ASCII characters (without unicode processing).
 */

public class SimpleCharStream {
  /** Whether parser is static. */
  public static final boolean staticFlag = false;
  /** buffer size */
  int bufsize;
  /** available */
  int available;
  /** tokenBegin */
  int tokenBegin;
  /** Position in buffer. */
  public int bufpos = -1;
  /** bufline */
  protected int bufline[];
  /** bufcolumn */
  protected int bufcolumn[];

  /** var */
  protected int column = 0;
  /** var */
  protected int line = 1;

  /** var */
  protected boolean prevCharIsCR = false;
  /** var */
  protected boolean prevCharIsLF = false;

  /** var */
  protected java.io.Reader inputStream;

  /** var */
  protected char[] buffer;
  /** var */
  protected int maxNextCharInd = 0;
  /** var */
  protected int inBuf = 0;
  /** var */
  protected int tabSize = 8;
  /** var */

  /**
   * Setter
   * @param i index
   */
  protected void setTabSize(int i) {
    tabSize = i;
  }

  /**
   *
   * Return tabSize
   * @param i index
   * @return tabSize
   */
  protected int getTabSize(int i) {
    return tabSize;
  }

  /**
   * Expand
   * @param wrapAround wrapAround
   */
  protected void ExpandBuff(boolean wrapAround) {
    char[] newbuffer = new char[bufsize + 2048];
    int newbufline[] = new int[bufsize + 2048];
    int newbufcolumn[] = new int[bufsize + 2048];

    try {
      if (wrapAround) {
        System.arraycopy(buffer, tokenBegin, newbuffer, 0, bufsize - tokenBegin);
        System.arraycopy(buffer, 0, newbuffer, bufsize - tokenBegin, bufpos);
        buffer = newbuffer;

        System.arraycopy(bufline, tokenBegin, newbufline, 0, bufsize - tokenBegin);
        System.arraycopy(bufline, 0, newbufline, bufsize - tokenBegin, bufpos);
        bufline = newbufline;

        System.arraycopy(bufcolumn, tokenBegin, newbufcolumn, 0, bufsize - tokenBegin);
        System.arraycopy(bufcolumn, 0, newbufcolumn, bufsize - tokenBegin, bufpos);
        bufcolumn = newbufcolumn;

        maxNextCharInd = (bufpos += (bufsize - tokenBegin));
      } else {
        System.arraycopy(buffer, tokenBegin, newbuffer, 0, bufsize - tokenBegin);
        buffer = newbuffer;

        System.arraycopy(bufline, tokenBegin, newbufline, 0, bufsize - tokenBegin);
        bufline = newbufline;

        System.arraycopy(bufcolumn, tokenBegin, newbufcolumn, 0, bufsize - tokenBegin);
        bufcolumn = newbufcolumn;

        maxNextCharInd = (bufpos -= tokenBegin);
      }
    } catch (Throwable t) {
      throw new Error(t.getMessage());
    }

    bufsize += 2048;
    available = bufsize;
    tokenBegin = 0;
  }

  /**
   * FillBuffer
   * @throws java.io.IOException error
   */
  protected void FillBuff() throws java.io.IOException {
    if (maxNextCharInd == available) {
      if (available == bufsize) {
        if (tokenBegin > 2048) {
          bufpos = maxNextCharInd = 0;
          available = tokenBegin;
        } else if (tokenBegin < 0)
          bufpos = maxNextCharInd = 0;
        else
          ExpandBuff(false);
      } else if (available > tokenBegin)
        available = bufsize;
      else if ((tokenBegin - available) < 2048)
        ExpandBuff(true);
      else
        available = tokenBegin;
    }

    int i;
    try {
      if ((i = inputStream.read(buffer, maxNextCharInd, available - maxNextCharInd)) == -1) {
        inputStream.close();
        throw new java.io.IOException();
      } else
        maxNextCharInd += i;
      return;
    } catch (java.io.IOException e) {
      --bufpos;
      backup(0);
      if (tokenBegin == -1)
        tokenBegin = bufpos;
      throw e;
    }
  }

  /**
   * Start.
   *
   * @return the begin token
   * @throws java.io.IOException error
   */
  public char BeginToken() throws java.io.IOException {
    tokenBegin = -1;
    char c = readChar();
    tokenBegin = bufpos;

    return c;
  }

  /**
   * Update line
   * @param c a char
   */
  protected void UpdateLineColumn(char c) {
    column++;

    if (prevCharIsLF) {
      prevCharIsLF = false;
      line += (column = 1);
    } else if (prevCharIsCR) {
      prevCharIsCR = false;
      if (c == '\n') {
        prevCharIsLF = true;
      } else
        line += (column = 1);
    }

    switch (c) {
      case '\r':
        prevCharIsCR = true;
        break;
      case '\n':
        prevCharIsLF = true;
        break;
      case '\t':
        column--;
        column += (tabSize - (column % tabSize));
        break;
      default:
        break;
    }

    bufline[bufpos] = line;
    bufcolumn[bufpos] = column;
  }

  /**
   * Read a character.
   *
   * @return a char
   * @throws java.io.IOException error
   */
  public char readChar() throws java.io.IOException {
    if (inBuf > 0) {
      --inBuf;

      if (++bufpos == bufsize)
        bufpos = 0;

      return buffer[bufpos];
    }

    if (++bufpos >= maxNextCharInd)
      FillBuff();

    char c = buffer[bufpos];

    UpdateLineColumn(c);
    return c;
  }

  /**
   * Return column
   *
   * @return column
   * @deprecated
   * @see #getEndColumn
   */
  @Deprecated
  public int getColumn() {
    return bufcolumn[bufpos];
  }

  /**
   *
   * Return line
   *
   * @return line
   * @deprecated
   * @see #getEndLine
   */
  @Deprecated
  public int getLine() {
    return bufline[bufpos];
  }

  /**
   * Get token end column number.
   *
   * @return column
   */
  public int getEndColumn() {
    return bufcolumn[bufpos];
  }

  /**
   * Get token end line number.
   *
   * @return line
   */
  public int getEndLine() {
    return bufline[bufpos];
  }

  /**
   * Retrieves the column number where the current token begins.
   *
   * @return The column number of the beginning of the current token.
   */
  public int getBeginColumn() {
    return bufcolumn[tokenBegin];
  }

  /**
   * Retrieves the line number where the current token begins.
   *
   * @return The line number of the beginning of the current token.
   */
  public int getBeginLine() {
    return bufline[tokenBegin];
  }

  /**
   * Rewinds the input stream by a specified number of characters.
   * This allows you to backtrack in the input stream if needed.
   *
   * @param amount The number of characters to move backwards. This should be a
   *               positive integer.
   */
  public void backup(int amount) {
    inBuf += amount;
    if ((bufpos -= amount) < 0) {
      bufpos += bufsize;
    }
  }

  /** Constructor. */
  /**
   * Constructs a {@code SimpleCharStream} with the specified reader, starting
   * line,
   * starting column, and buffer size.
   *
   * @param dstream     The input reader from which characters are read.
   * @param startline   The line number where reading starts.
   * @param startcolumn The column number where reading starts.
   * @param buffersize  The size of the character buffer.
   */
  public SimpleCharStream(java.io.Reader dstream, int startline, int startcolumn, int buffersize) {
    inputStream = dstream;
    line = startline;
    column = startcolumn - 1;
    available = bufsize = buffersize;
    buffer = new char[buffersize];
    bufline = new int[buffersize];
    bufcolumn = new int[buffersize];
  }

  /**
   * Constructs a {@code SimpleCharStream} with the specified reader, starting
   * line,
   * and starting column. The buffer size is set to 4096 characters.
   *
   * @param dstream     The input reader from which characters are read.
   * @param startline   The line number where reading starts.
   * @param startcolumn The column number where reading starts.
   */
  public SimpleCharStream(java.io.Reader dstream, int startline, int startcolumn) {
    this(dstream, startline, startcolumn, 4096);
  }

  /**
   * Constructs a {@code SimpleCharStream} with the specified reader. The starting
   * line and column are set to 1, and the buffer size is set to 4096 characters.
   *
   * @param dstream The input reader from which characters are read.
   */
  public SimpleCharStream(java.io.Reader dstream) {
    this(dstream, 1, 1, 4096);
  }

  /**
   * Reinitializes the {@code SimpleCharStream} with the specified reader,
   * starting
   * line, starting column, and buffer size. This method also resets the internal
   * state of the stream.
   *
   * @param dstream     The new input reader from which characters are read.
   * @param startline   The new line number where reading starts.
   * @param startcolumn The new column number where reading starts.
   * @param buffersize  The new size of the character buffer.
   */
  public void ReInit(java.io.Reader dstream, int startline, int startcolumn, int buffersize) {
    inputStream = dstream;
    line = startline;
    column = startcolumn - 1;

    if (buffer == null || buffersize != buffer.length) {
      available = bufsize = buffersize;
      buffer = new char[buffersize];
      bufline = new int[buffersize];
      bufcolumn = new int[buffersize];
    }
    prevCharIsLF = prevCharIsCR = false;
    tokenBegin = inBuf = maxNextCharInd = 0;
    bufpos = -1;
  }

  /**
   * Reinitializes the {@code SimpleCharStream} with the specified reader,
   * starting line,
   * and starting column. The buffer size is set to 4096 characters.
   *
   * @param dstream     The new input reader from which characters are read.
   * @param startline   The new line number where reading starts.
   * @param startcolumn The new column number where reading starts.
   */
  public void ReInit(java.io.Reader dstream, int startline, int startcolumn) {
    ReInit(dstream, startline, startcolumn, 4096);
  }

  /**
   * Reinitializes the {@code SimpleCharStream} with the specified reader. The
   * starting
   * line and column are set to 1, and the buffer size is set to 4096 characters.
   *
   * @param dstream The new input reader from which characters are read.
   */
  public void ReInit(java.io.Reader dstream) {
    ReInit(dstream, 1, 1, 4096);
  }

  /**
   * Constructs a {@code SimpleCharStream} with the specified input stream,
   * encoding, starting line,
   * starting column, and buffer size.
   *
   * @param dstream     The input stream from which characters are read.
   * @param encoding    The character encoding to use.
   * @param startline   The line number where reading starts.
   * @param startcolumn The column number where reading starts.
   * @param buffersize  The size of the character buffer.
   * @throws java.io.UnsupportedEncodingException If the specified encoding is not
   *                                              supported.
   */
  public SimpleCharStream(java.io.InputStream dstream, String encoding, int startline,
      int startcolumn, int buffersize) throws java.io.UnsupportedEncodingException {
    this(encoding == null ? new java.io.InputStreamReader(dstream) : new java.io.InputStreamReader(dstream, encoding),
        startline, startcolumn, buffersize);
  }

  /**
   * Constructs a {@code SimpleCharStream} with the specified input stream,
   * starting line,
   * starting column, and buffer size. Uses the default encoding for reading.
   *
   * @param dstream     The input stream from which characters are read.
   * @param startline   The line number where reading starts.
   * @param startcolumn The column number where reading starts.
   * @param buffersize  The size of the character buffer.
   */
  public SimpleCharStream(java.io.InputStream dstream, int startline, int startcolumn, int buffersize) {
    this(new java.io.InputStreamReader(dstream), startline, startcolumn, buffersize);
  }

  /**
   * Constructs a {@code SimpleCharStream} with the specified input stream,
   * encoding, starting line,
   * and starting column. The buffer size is set to 4096 characters.
   *
   * @param dstream     The input stream from which characters are read.
   * @param encoding    The character encoding to use.
   * @param startline   The line number where reading starts.
   * @param startcolumn The column number where reading starts.
   * @throws java.io.UnsupportedEncodingException If the specified encoding is not
   *                                              supported.
   */
  public SimpleCharStream(java.io.InputStream dstream, String encoding, int startline,
      int startcolumn) throws java.io.UnsupportedEncodingException {
    this(dstream, encoding, startline, startcolumn, 4096);
  }

  /**
   * Constructs a {@code SimpleCharStream} with the specified input stream,
   * starting line,
   * and starting column. The buffer size is set to 4096 characters.
   *
   * @param dstream     The input stream from which characters are read.
   * @param startline   The line number where reading starts.
   * @param startcolumn The column number where reading starts.
   */
  public SimpleCharStream(java.io.InputStream dstream, int startline, int startcolumn) {
    this(dstream, startline, startcolumn, 4096);
  }

  /**
   * Constructs a {@code SimpleCharStream} with the specified input stream and
   * encoding.
   * The starting line and column are set to 1, and the buffer size is set to 4096
   * characters.
   *
   * @param dstream  The input stream from which characters are read.
   * @param encoding The character encoding to use.
   * @throws java.io.UnsupportedEncodingException If the specified encoding is not
   *                                              supported.
   */
  public SimpleCharStream(java.io.InputStream dstream, String encoding) throws java.io.UnsupportedEncodingException {
    this(dstream, encoding, 1, 1, 4096);
  }

  /**
   * Constructs a {@code SimpleCharStream} with the specified input stream. The
   * starting
   * line and column are set to 1, and the buffer size is set to 4096 characters.
   *
   * @param dstream The input stream from which characters are read.
   */
  public SimpleCharStream(java.io.InputStream dstream) {
    this(dstream, 1, 1, 4096);
  }

  /**
   * Reinitializes the {@code SimpleCharStream} with the specified input stream,
   * encoding, starting line,
   * starting column, and buffer size.
   *
   * @param dstream     The input stream from which characters are read.
   * @param encoding    The character encoding to use. If {@code null}, the
   *                    default encoding is used.
   * @param startline   The line number where reading starts.
   * @param startcolumn The column number where reading starts.
   * @param buffersize  The size of the character buffer.
   * @throws java.io.UnsupportedEncodingException If the specified encoding is not
   *                                              supported.
   */
  public void ReInit(java.io.InputStream dstream, String encoding, int startline,
      int startcolumn, int buffersize) throws java.io.UnsupportedEncodingException {
    ReInit(encoding == null ? new java.io.InputStreamReader(dstream) : new java.io.InputStreamReader(dstream, encoding),
        startline, startcolumn, buffersize);
  }

  /**
   * Reinitializes the {@code SimpleCharStream} with the specified input stream,
   * starting line,
   * starting column, and buffer size. Uses the default encoding.
   *
   * @param dstream     The input stream from which characters are read.
   * @param startline   The line number where reading starts.
   * @param startcolumn The column number where reading starts.
   * @param buffersize  The size of the character buffer.
   */
  public void ReInit(java.io.InputStream dstream, int startline,
      int startcolumn, int buffersize) {
    ReInit(new java.io.InputStreamReader(dstream), startline, startcolumn, buffersize);
  }

  /**
   * Reinitializes the {@code SimpleCharStream} with the specified input stream
   * and encoding. The starting
   * line and column are set to 1, and the buffer size is set to 4096 characters.
   *
   * @param dstream  The input stream from which characters are read.
   * @param encoding The character encoding to use.
   * @throws java.io.UnsupportedEncodingException If the specified encoding is not
   *                                              supported.
   */
  public void ReInit(java.io.InputStream dstream, String encoding) throws java.io.UnsupportedEncodingException {
    ReInit(dstream, encoding, 1, 1, 4096);
  }

  /**
   * Reinitializes the {@code SimpleCharStream} with the specified input stream.
   * The starting line and
   * column are set to 1, and the buffer size is set to 4096 characters.
   *
   * @param dstream The input stream from which characters are read.
   */
  public void ReInit(java.io.InputStream dstream) {
    ReInit(dstream, 1, 1, 4096);
  }

  /**
   * Reinitializes the {@code SimpleCharStream} with the specified input stream,
   * encoding, starting line,
   * and starting column. The buffer size is set to 4096 characters.
   *
   * @param dstream     The input stream from which characters are read.
   * @param encoding    The character encoding to use.
   * @param startline   The line number where reading starts.
   * @param startcolumn The column number where reading starts.
   * @throws java.io.UnsupportedEncodingException If the specified encoding is not
   *                                              supported.
   */
  public void ReInit(java.io.InputStream dstream, String encoding, int startline,
      int startcolumn) throws java.io.UnsupportedEncodingException {
    ReInit(dstream, encoding, startline, startcolumn, 4096);
  }

  /**
   * Reinitializes the {@code SimpleCharStream} with the specified input stream,
   * starting line, and
   * starting column. The buffer size is set to 4096 characters. Uses the default
   * encoding.
   *
   * @param dstream     The input stream from which characters are read.
   * @param startline   The line number where reading starts.
   * @param startcolumn The column number where reading starts.
   */
  public void ReInit(java.io.InputStream dstream, int startline, int startcolumn) {
    ReInit(dstream, startline, startcolumn, 4096);
  }

  /** Get token literal value.
   * @return a token
  */
  public String GetImage() {
    if (bufpos >= tokenBegin)
      return new String(buffer, tokenBegin, bufpos - tokenBegin + 1);
    else
      return new String(buffer, tokenBegin, bufsize - tokenBegin) +
          new String(buffer, 0, bufpos + 1);
  }

  /**
   * Get the suffix.
   *
   * @param len  size
   * @return the suffix
   */
  public char[] GetSuffix(int len) {
    char[] ret = new char[len];

    if ((bufpos + 1) >= len)
      System.arraycopy(buffer, bufpos - len + 1, ret, 0, len);
    else {
      System.arraycopy(buffer, bufsize - (len - bufpos - 1), ret, 0,
          len - bufpos - 1);
      System.arraycopy(buffer, 0, ret, len - bufpos - 1, bufpos + 1);
    }

    return ret;
  }

  /** Reset buffer when finished. */
  public void Done() {
    buffer = null;
    bufline = null;
    bufcolumn = null;
  }

  /**
   * Method to adjust line and column numbers for the start of a token.
   *
   * @param newLine line
   * @param newCol  col
   */
  public void adjustBeginLineColumn(int newLine, int newCol) {
    int start = tokenBegin;
    int len;

    if (bufpos >= tokenBegin) {
      len = bufpos - tokenBegin + inBuf + 1;
    } else {
      len = bufsize - tokenBegin + bufpos + 1 + inBuf;
    }

    int i = 0, j = 0, k = 0;
    int nextColDiff = 0, columnDiff = 0;

    while (i < len && bufline[j = start % bufsize] == bufline[k = ++start % bufsize]) {
      bufline[j] = newLine;
      nextColDiff = columnDiff + bufcolumn[k] - bufcolumn[j];
      bufcolumn[j] = newCol + columnDiff;
      columnDiff = nextColDiff;
      i++;
    }

    if (i < len) {
      bufline[j] = newLine++;
      bufcolumn[j] = newCol + columnDiff;

      while (i++ < len) {
        if (bufline[j = start % bufsize] != bufline[++start % bufsize])
          bufline[j] = newLine++;
        else
          bufline[j] = newLine;
      }
    }

    line = bufline[j];
    column = bufcolumn[j];
  }

}
/**
 * JavaCC - OriginalChecksum=52ec67f9e2260f46790c7eeb222c0a62 (do not edit this
 * line)
 */
